#ifndef _HEADERS_FUNCTIONS_H
#define _HEADERS_FUNCTIONS_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool OpenLogFile(void)
{
    char FullFileName[256];

    SYSTEMTIME ST;

    GetLocalTime(&ST);

    char DateTemp[64 + 1];

    GetDateFormat(LOCALE_USER_DEFAULT, NULL, &ST, "MM-dd-yy", DateTemp,64);

    sprintf(FullFileName, "%s\\%s.txt", gsSessionLogDir, DateTemp);

    if( (gfSessionLog = fopen(FullFileName, "ab")) == NULL)
        return false;

    return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void WriteLog(char *xMessage)
{
    SYSTEMTIME ST;
    GetLocalTime(&ST);

    char lsDate[64];
    char lsTime[64];

    GetDateFormat(LOCALE_USER_DEFAULT, DATE_SHORTDATE, &ST, NULL, lsDate, 64);
    GetTimeFormat(LOCALE_USER_DEFAULT, 0, &ST, NULL, lsTime, 64);

    fprintf(gfSessionLog, "(%s %s) | %s\r\n", lsDate, lsTime, xMessage);
    InsertListBoxItem(MDI.RecvEdit_hWnd, xMessage, -1);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void FatalError(char *xMessage)
{
    MessageBox(GetActiveWindow(), xMessage, TitleCaption, MB_ICONHAND + MB_SYSTEMMODAL);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool WaitOnApplicationToExit(void)
{
    gbKillApplication = true; // Tell application to exit

    if(gbIsClientDialogOpen)
    {
        EndDialog(MainDialog_hWnd, 0);
    }

    while(gbApplicationRunning) // Wait on application to exit
    {
        Sleep(1);
    }

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool xMainEntry(void)
{
    gbApplicationRunning = true;

    if(!Initialize())
    {
		MessageBox (NULL, "Failed to initialize!", TitleCaption, MB_ICONHAND | MB_SYSTEMMODAL);
		return false;
    }

    WriteLog("Client started.");

	Timer_Thread_Handle = CreateThread(NULL, 0, Timer_Thread, (LPVOID)0, 0, &Timer_Thread_ID);

    while(!gbKillApplication)
    {
    	if(WaitForSingleObject(OpenISQLExgClientMainDialog_Handle, 0) == WAIT_OBJECT_0)
        {
            DialogBox(MainInstance, MAKEINTRESOURCE(IDD_MAIN), 0, MainDialog);
        }

        Sleep(1);
    }

    WriteLog("Client stopped.");

    if(!Uninitialize())
    {
		MessageBox (NULL, "Failed to uninitialize!", TitleCaption, MB_ICONHAND | MB_SYSTEMMODAL);
		return false;
    }

    gbApplicationRunning = false;

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ClientSend(char *String, int Length)
{
    while( !MyClient.SetSendDataEx(String, Length) && MyClient.Connected )
        Sleep(1);

    return MyClient.Connected;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SimpleClientSend(char *Text)
{
    return ClientSend(Text, strlen(Text));
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool DoConnect(void)
{

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool DoDisconnect(void)
{
    WriteLog("Disconnected.");

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool GetRegistryValues(void)
{
	DWORD SizeofString = 0;

    SizeofString = sizeof(gsPath);
	memset(gsPath, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "Path", gsPath, SizeofString))
        return false;

    SizeofString = sizeof(gsSQLServer);
	memset(gsSQLServer, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SQLServer", gsSQLServer, SizeofString))
        return false;

    SizeofString = sizeof(gsSQLUserID);
	memset(gsSQLUserID, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SQLUserID", gsSQLUserID, SizeofString))
        return false;

    SizeofString = sizeof(gsSQLPassword);
	memset(gsSQLPassword, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SQLPassword", gsSQLPassword, SizeofString))
        return false;

    SizeofString = sizeof(gsSQLDriver);
	memset(gsSQLDriver, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SQLDriver", gsSQLDriver, SizeofString))
        return false;

    SizeofString = sizeof(gsSQLDatabase);
	memset(gsSQLDatabase, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SQLDatabase", gsSQLDatabase, SizeofString))
        return false;

    SizeofString = sizeof(gsWPServer);
	memset(gsWPServer, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "WPServer", gsWPServer, SizeofString))
        return false;

    SizeofString = sizeof(gsBaseCommKey);
	memset(gsBaseCommKey, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "BaseCommKey", gsBaseCommKey, SizeofString))
        return false;

    SizeofString = sizeof(gsAuthString);
	memset(gsAuthString, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "AuthString", gsAuthString, SizeofString))
        return false;

    SizeofString = sizeof(gsCompanyName);
	memset(gsCompanyName, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "CompanyName", gsCompanyName, SizeofString))
        return false;

    SizeofString = sizeof(gsCompanyPassword);
	memset(gsCompanyPassword, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "CompanyPassword", gsCompanyPassword, SizeofString))
        return false;

    SizeofString = sizeof(gsBaseCommKey);
	memset(gsBaseCommKey, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "BaseCommKey", gsBaseCommKey, SizeofString))
        return false;

    SizeofString = sizeof(gsSessionLogDir);
	memset(gsSessionLogDir, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SessionLogDir", gsSessionLogDir, SizeofString))
        return false;

    SizeofString = sizeof(gsSQLExportTempFile);
	memset(gsSQLExportTempFile, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SQLExportTempFile", gsSQLExportTempFile, SizeofString))
        return false;

	if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "TCPLoopDelay", glTCPLoopDelay))
        return false;

    if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "ConnectPort", glConnectPort))
        return false;

    if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "ConnectInterval", glConnectInterval))
        return false;

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SaveRegistryValues(void)
{
    if(!Set_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SQLServer", gsSQLServer))
        return false;

    if(!Set_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SQLUserID", gsSQLUserID))
        return false;

    if(!Set_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SQLPassword", gsSQLPassword))
        return false;

    if(!Set_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SQLDriver", gsSQLDriver))
        return false;

    if(!Set_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SQLDatabase", gsSQLDatabase))
        return false;

    if(!Set_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "WPServer", gsWPServer))
        return false;

    if(!Set_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "BaseCommKey", gsBaseCommKey))
        return false;

    if(!Set_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SessionLogDir", gsSessionLogDir))
        return false;

    if(!Set_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SQLExportTempFile", gsSQLExportTempFile))
        return false;

    if(!Set_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "AuthString", gsAuthString))
        return false;

    if(!Set_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "CompanyName", gsCompanyName))
        return false;

    if(!Set_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "CompanyPassword", gsCompanyPassword))
        return false;

    if(!Set_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "BaseCommKey", gsBaseCommKey))
        return false;

    //------------------------

	if(!Set_DWORDRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "TCPLoopDelay", glTCPLoopDelay))
        return false;

    if(!Set_DWORDRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "ConnectPort", glConnectPort))
        return false;

    if(!Set_DWORDRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "ConnectInterval", glConnectInterval))
        return false;

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

